"use strict";module.exports = validate20;module.exports.default = validate20;const schema22 = {"$schema":"http://json-schema.org/draft-07/schema#","type":"object","title":"ModuleManifest","properties":{"$schema":{"type":"string"},"id":{"type":"string","description":"Unique identifier for the module"},"name":{"type":"string","description":"Name of the module"},"shortname":{"type":"string"},"description":{"type":"string","description":"Description of the module "},"version":{"type":"string","description":"Current version of the module"},"license":{"type":"string","description":"SPDX identifier for license of the module"},"repository":{"type":"string","description":"URL to the source repository"},"bugs":{"type":"string","description":"URL to bug tracker"},"maintainers":{"type":"array","description":"List of active maintiners","uniqueItems":true,"items":{"type":"object","title":"ModuleManifestMaintainer","properties":{"name":{"type":"string"},"email":{"type":"string"},"github":{"type":"string"}},"required":["name"]}},"legacyIds":{"type":"array","description":"If the module had a different unique identifier previously, then specify it here","uniqueItems":true,"items":{"type":"string"}},"runtime":{"type":"object","title":"ModuleManifestRuntime","description":"Information on how to execute the module","properties":{"type":{"type":"string","description":"Type of the module. Must be: node18 or node22","enum":["node18","node22"]},"api":{"type":"string","description":"Which host-api does it use. In the future alternate options will be allowed","enum":["nodejs-ipc"]},"apiVersion":{"type":"string","description":"The version of the host-api used"},"entrypoint":{"type":"string","description":"Entrypoint to pass to the runtime. eg index.js"}},"required":["type","api","apiVersion","entrypoint"]},"manufacturer":{"type":"string"},"products":{"type":"array","uniqueItems":true,"items":{"type":"string"},"minItems":1},"keywords":{"type":"array","uniqueItems":true,"items":{"type":"string"}},"bonjourQueries":{"type":"object","description":"If the device or software for your module supports bonjour announcements, Companion will offer an easy way to watch for these announcements.\nEach query you define must have a matching config field of type 'bonjour-device' with the same name","patternProperties":{"":{"oneOf":[{"$ref":"#/definitions/bonjourQuery"},{"type":"array","items":{"$ref":"#/definitions/bonjourQuery"}}]}},"additionalProperties":false}},"additionalProperties":false,"required":["id","name","shortname","description","version","license","repository","bugs","maintainers","legacyIds","runtime","manufacturer","products","keywords"],"definitions":{"bonjourQuery":{"type":"object","title":"ModuleBonjourQuery","description":"","properties":{"type":{"type":"string"},"protocol":{"type":"string","enum":["tcp","udp"]},"txt":{"type":"object","description":"Match on any txt values returned in the query. This is useful to filter out devices of the same 'type' that are not supported","patternProperties":{"":{"type":"string"}},"additionalProperties":false}},"required":["type","protocol"],"additionalProperties":false}}};const schema23 = {"type":"object","title":"ModuleBonjourQuery","description":"","properties":{"type":{"type":"string"},"protocol":{"type":"string","enum":["tcp","udp"]},"txt":{"type":"object","description":"Match on any txt values returned in the query. This is useful to filter out devices of the same 'type' that are not supported","patternProperties":{"":{"type":"string"}},"additionalProperties":false}},"required":["type","protocol"],"additionalProperties":false};const func4 = Object.prototype.hasOwnProperty;const func0 = require("ajv/dist/runtime/equal").default;const pattern0 = new RegExp("", "u");function validate20(data, {instancePath="", parentData, parentDataProperty, rootData=data}={}){let vErrors = null;let errors = 0;if(errors === 0){if(data && typeof data == "object" && !Array.isArray(data)){let missing0;if(((((((((((((((data.id === undefined) && (missing0 = "id")) || ((data.name === undefined) && (missing0 = "name"))) || ((data.shortname === undefined) && (missing0 = "shortname"))) || ((data.description === undefined) && (missing0 = "description"))) || ((data.version === undefined) && (missing0 = "version"))) || ((data.license === undefined) && (missing0 = "license"))) || ((data.repository === undefined) && (missing0 = "repository"))) || ((data.bugs === undefined) && (missing0 = "bugs"))) || ((data.maintainers === undefined) && (missing0 = "maintainers"))) || ((data.legacyIds === undefined) && (missing0 = "legacyIds"))) || ((data.runtime === undefined) && (missing0 = "runtime"))) || ((data.manufacturer === undefined) && (missing0 = "manufacturer"))) || ((data.products === undefined) && (missing0 = "products"))) || ((data.keywords === undefined) && (missing0 = "keywords"))){validate20.errors = [{instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty: missing0},message:"must have required property '"+missing0+"'"}];return false;}else {const _errs1 = errors;for(const key0 in data){if(!(func4.call(schema22.properties, key0))){validate20.errors = [{instancePath,schemaPath:"#/additionalProperties",keyword:"additionalProperties",params:{additionalProperty: key0},message:"must NOT have additional properties"}];return false;break;}}if(_errs1 === errors){if(data.$schema !== undefined){const _errs2 = errors;if(typeof data.$schema !== "string"){validate20.errors = [{instancePath:instancePath+"/$schema",schemaPath:"#/properties/%24schema/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs2 === errors;}else {var valid0 = true;}if(valid0){if(data.id !== undefined){const _errs4 = errors;if(typeof data.id !== "string"){validate20.errors = [{instancePath:instancePath+"/id",schemaPath:"#/properties/id/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs4 === errors;}else {var valid0 = true;}if(valid0){if(data.name !== undefined){const _errs6 = errors;if(typeof data.name !== "string"){validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs6 === errors;}else {var valid0 = true;}if(valid0){if(data.shortname !== undefined){const _errs8 = errors;if(typeof data.shortname !== "string"){validate20.errors = [{instancePath:instancePath+"/shortname",schemaPath:"#/properties/shortname/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs8 === errors;}else {var valid0 = true;}if(valid0){if(data.description !== undefined){const _errs10 = errors;if(typeof data.description !== "string"){validate20.errors = [{instancePath:instancePath+"/description",schemaPath:"#/properties/description/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs10 === errors;}else {var valid0 = true;}if(valid0){if(data.version !== undefined){const _errs12 = errors;if(typeof data.version !== "string"){validate20.errors = [{instancePath:instancePath+"/version",schemaPath:"#/properties/version/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs12 === errors;}else {var valid0 = true;}if(valid0){if(data.license !== undefined){const _errs14 = errors;if(typeof data.license !== "string"){validate20.errors = [{instancePath:instancePath+"/license",schemaPath:"#/properties/license/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs14 === errors;}else {var valid0 = true;}if(valid0){if(data.repository !== undefined){const _errs16 = errors;if(typeof data.repository !== "string"){validate20.errors = [{instancePath:instancePath+"/repository",schemaPath:"#/properties/repository/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs16 === errors;}else {var valid0 = true;}if(valid0){if(data.bugs !== undefined){const _errs18 = errors;if(typeof data.bugs !== "string"){validate20.errors = [{instancePath:instancePath+"/bugs",schemaPath:"#/properties/bugs/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs18 === errors;}else {var valid0 = true;}if(valid0){if(data.maintainers !== undefined){let data9 = data.maintainers;const _errs20 = errors;if(errors === _errs20){if(Array.isArray(data9)){var valid1 = true;const len0 = data9.length;for(let i0=0; i0<len0; i0++){let data10 = data9[i0];const _errs22 = errors;if(errors === _errs22){if(data10 && typeof data10 == "object" && !Array.isArray(data10)){let missing1;if((data10.name === undefined) && (missing1 = "name")){validate20.errors = [{instancePath:instancePath+"/maintainers/" + i0,schemaPath:"#/properties/maintainers/items/required",keyword:"required",params:{missingProperty: missing1},message:"must have required property '"+missing1+"'"}];return false;}else {if(data10.name !== undefined){const _errs24 = errors;if(typeof data10.name !== "string"){validate20.errors = [{instancePath:instancePath+"/maintainers/" + i0+"/name",schemaPath:"#/properties/maintainers/items/properties/name/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid2 = _errs24 === errors;}else {var valid2 = true;}if(valid2){if(data10.email !== undefined){const _errs26 = errors;if(typeof data10.email !== "string"){validate20.errors = [{instancePath:instancePath+"/maintainers/" + i0+"/email",schemaPath:"#/properties/maintainers/items/properties/email/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid2 = _errs26 === errors;}else {var valid2 = true;}if(valid2){if(data10.github !== undefined){const _errs28 = errors;if(typeof data10.github !== "string"){validate20.errors = [{instancePath:instancePath+"/maintainers/" + i0+"/github",schemaPath:"#/properties/maintainers/items/properties/github/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid2 = _errs28 === errors;}else {var valid2 = true;}}}}}else {validate20.errors = [{instancePath:instancePath+"/maintainers/" + i0,schemaPath:"#/properties/maintainers/items/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}var valid1 = _errs22 === errors;if(!valid1){break;}}if(valid1){let i1 = data9.length;let j0;if(i1 > 1){outer0:for(;i1--;){for(j0 = i1; j0--;){if(func0(data9[i1], data9[j0])){validate20.errors = [{instancePath:instancePath+"/maintainers",schemaPath:"#/properties/maintainers/uniqueItems",keyword:"uniqueItems",params:{i: i1, j: j0},message:"must NOT have duplicate items (items ## "+j0+" and "+i1+" are identical)"}];return false;break outer0;}}}}}}else {validate20.errors = [{instancePath:instancePath+"/maintainers",schemaPath:"#/properties/maintainers/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs20 === errors;}else {var valid0 = true;}if(valid0){if(data.legacyIds !== undefined){let data14 = data.legacyIds;const _errs30 = errors;if(errors === _errs30){if(Array.isArray(data14)){var valid4 = true;const len1 = data14.length;for(let i2=0; i2<len1; i2++){const _errs32 = errors;if(typeof data14[i2] !== "string"){validate20.errors = [{instancePath:instancePath+"/legacyIds/" + i2,schemaPath:"#/properties/legacyIds/items/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid4 = _errs32 === errors;if(!valid4){break;}}if(valid4){let i3 = data14.length;let j1;if(i3 > 1){const indices0 = {};for(;i3--;){let item0 = data14[i3];if(typeof item0 !== "string"){continue;}if(typeof indices0[item0] == "number"){j1 = indices0[item0];validate20.errors = [{instancePath:instancePath+"/legacyIds",schemaPath:"#/properties/legacyIds/uniqueItems",keyword:"uniqueItems",params:{i: i3, j: j1},message:"must NOT have duplicate items (items ## "+j1+" and "+i3+" are identical)"}];return false;break;}indices0[item0] = i3;}}}}else {validate20.errors = [{instancePath:instancePath+"/legacyIds",schemaPath:"#/properties/legacyIds/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs30 === errors;}else {var valid0 = true;}if(valid0){if(data.runtime !== undefined){let data16 = data.runtime;const _errs34 = errors;if(errors === _errs34){if(data16 && typeof data16 == "object" && !Array.isArray(data16)){let missing2;if(((((data16.type === undefined) && (missing2 = "type")) || ((data16.api === undefined) && (missing2 = "api"))) || ((data16.apiVersion === undefined) && (missing2 = "apiVersion"))) || ((data16.entrypoint === undefined) && (missing2 = "entrypoint"))){validate20.errors = [{instancePath:instancePath+"/runtime",schemaPath:"#/properties/runtime/required",keyword:"required",params:{missingProperty: missing2},message:"must have required property '"+missing2+"'"}];return false;}else {if(data16.type !== undefined){let data17 = data16.type;const _errs36 = errors;if(typeof data17 !== "string"){validate20.errors = [{instancePath:instancePath+"/runtime/type",schemaPath:"#/properties/runtime/properties/type/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}if(!((data17 === "node18") || (data17 === "node22"))){validate20.errors = [{instancePath:instancePath+"/runtime/type",schemaPath:"#/properties/runtime/properties/type/enum",keyword:"enum",params:{allowedValues: schema22.properties.runtime.properties.type.enum},message:"must be equal to one of the allowed values"}];return false;}var valid6 = _errs36 === errors;}else {var valid6 = true;}if(valid6){if(data16.api !== undefined){let data18 = data16.api;const _errs38 = errors;if(typeof data18 !== "string"){validate20.errors = [{instancePath:instancePath+"/runtime/api",schemaPath:"#/properties/runtime/properties/api/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}if(!(data18 === "nodejs-ipc")){validate20.errors = [{instancePath:instancePath+"/runtime/api",schemaPath:"#/properties/runtime/properties/api/enum",keyword:"enum",params:{allowedValues: schema22.properties.runtime.properties.api.enum},message:"must be equal to one of the allowed values"}];return false;}var valid6 = _errs38 === errors;}else {var valid6 = true;}if(valid6){if(data16.apiVersion !== undefined){const _errs40 = errors;if(typeof data16.apiVersion !== "string"){validate20.errors = [{instancePath:instancePath+"/runtime/apiVersion",schemaPath:"#/properties/runtime/properties/apiVersion/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid6 = _errs40 === errors;}else {var valid6 = true;}if(valid6){if(data16.entrypoint !== undefined){const _errs42 = errors;if(typeof data16.entrypoint !== "string"){validate20.errors = [{instancePath:instancePath+"/runtime/entrypoint",schemaPath:"#/properties/runtime/properties/entrypoint/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid6 = _errs42 === errors;}else {var valid6 = true;}}}}}}else {validate20.errors = [{instancePath:instancePath+"/runtime",schemaPath:"#/properties/runtime/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}var valid0 = _errs34 === errors;}else {var valid0 = true;}if(valid0){if(data.manufacturer !== undefined){const _errs44 = errors;if(typeof data.manufacturer !== "string"){validate20.errors = [{instancePath:instancePath+"/manufacturer",schemaPath:"#/properties/manufacturer/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs44 === errors;}else {var valid0 = true;}if(valid0){if(data.products !== undefined){let data22 = data.products;const _errs46 = errors;if(errors === _errs46){if(Array.isArray(data22)){if(data22.length < 1){validate20.errors = [{instancePath:instancePath+"/products",schemaPath:"#/properties/products/minItems",keyword:"minItems",params:{limit: 1},message:"must NOT have fewer than 1 items"}];return false;}else {var valid7 = true;const len2 = data22.length;for(let i4=0; i4<len2; i4++){const _errs48 = errors;if(typeof data22[i4] !== "string"){validate20.errors = [{instancePath:instancePath+"/products/" + i4,schemaPath:"#/properties/products/items/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid7 = _errs48 === errors;if(!valid7){break;}}if(valid7){let i5 = data22.length;let j2;if(i5 > 1){const indices1 = {};for(;i5--;){let item1 = data22[i5];if(typeof item1 !== "string"){continue;}if(typeof indices1[item1] == "number"){j2 = indices1[item1];validate20.errors = [{instancePath:instancePath+"/products",schemaPath:"#/properties/products/uniqueItems",keyword:"uniqueItems",params:{i: i5, j: j2},message:"must NOT have duplicate items (items ## "+j2+" and "+i5+" are identical)"}];return false;break;}indices1[item1] = i5;}}}}}else {validate20.errors = [{instancePath:instancePath+"/products",schemaPath:"#/properties/products/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs46 === errors;}else {var valid0 = true;}if(valid0){if(data.keywords !== undefined){let data24 = data.keywords;const _errs50 = errors;if(errors === _errs50){if(Array.isArray(data24)){var valid9 = true;const len3 = data24.length;for(let i6=0; i6<len3; i6++){const _errs52 = errors;if(typeof data24[i6] !== "string"){validate20.errors = [{instancePath:instancePath+"/keywords/" + i6,schemaPath:"#/properties/keywords/items/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid9 = _errs52 === errors;if(!valid9){break;}}if(valid9){let i7 = data24.length;let j3;if(i7 > 1){const indices2 = {};for(;i7--;){let item2 = data24[i7];if(typeof item2 !== "string"){continue;}if(typeof indices2[item2] == "number"){j3 = indices2[item2];validate20.errors = [{instancePath:instancePath+"/keywords",schemaPath:"#/properties/keywords/uniqueItems",keyword:"uniqueItems",params:{i: i7, j: j3},message:"must NOT have duplicate items (items ## "+j3+" and "+i7+" are identical)"}];return false;break;}indices2[item2] = i7;}}}}else {validate20.errors = [{instancePath:instancePath+"/keywords",schemaPath:"#/properties/keywords/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs50 === errors;}else {var valid0 = true;}if(valid0){if(data.bonjourQueries !== undefined){let data26 = data.bonjourQueries;const _errs54 = errors;if(errors === _errs54){if(data26 && typeof data26 == "object" && !Array.isArray(data26)){const _errs56 = errors;for(const key1 in data26){if(!(pattern0.test(key1))){validate20.errors = [{instancePath:instancePath+"/bonjourQueries",schemaPath:"#/properties/bonjourQueries/additionalProperties",keyword:"additionalProperties",params:{additionalProperty: key1},message:"must NOT have additional properties"}];return false;break;}}if(_errs56 === errors){var valid11 = true;for(const key2 in data26){if(pattern0.test(key2)){let data27 = data26[key2];const _errs57 = errors;const _errs58 = errors;let valid12 = false;let passing0 = null;const _errs59 = errors;const _errs60 = errors;if(errors === _errs60){if(data27 && typeof data27 == "object" && !Array.isArray(data27)){let missing3;if(((data27.type === undefined) && (missing3 = "type")) || ((data27.protocol === undefined) && (missing3 = "protocol"))){const err0 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/definitions/bonjourQuery/required",keyword:"required",params:{missingProperty: missing3},message:"must have required property '"+missing3+"'"};if(vErrors === null){vErrors = [err0];}else {vErrors.push(err0);}errors++;}else {const _errs62 = errors;for(const key3 in data27){if(!(((key3 === "type") || (key3 === "protocol")) || (key3 === "txt"))){const err1 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/definitions/bonjourQuery/additionalProperties",keyword:"additionalProperties",params:{additionalProperty: key3},message:"must NOT have additional properties"};if(vErrors === null){vErrors = [err1];}else {vErrors.push(err1);}errors++;break;}}if(_errs62 === errors){if(data27.type !== undefined){const _errs63 = errors;if(typeof data27.type !== "string"){const err2 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/type",schemaPath:"#/definitions/bonjourQuery/properties/type/type",keyword:"type",params:{type: "string"},message:"must be string"};if(vErrors === null){vErrors = [err2];}else {vErrors.push(err2);}errors++;}var valid14 = _errs63 === errors;}else {var valid14 = true;}if(valid14){if(data27.protocol !== undefined){let data29 = data27.protocol;const _errs65 = errors;if(typeof data29 !== "string"){const err3 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/protocol",schemaPath:"#/definitions/bonjourQuery/properties/protocol/type",keyword:"type",params:{type: "string"},message:"must be string"};if(vErrors === null){vErrors = [err3];}else {vErrors.push(err3);}errors++;}if(!((data29 === "tcp") || (data29 === "udp"))){const err4 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/protocol",schemaPath:"#/definitions/bonjourQuery/properties/protocol/enum",keyword:"enum",params:{allowedValues: schema23.properties.protocol.enum},message:"must be equal to one of the allowed values"};if(vErrors === null){vErrors = [err4];}else {vErrors.push(err4);}errors++;}var valid14 = _errs65 === errors;}else {var valid14 = true;}if(valid14){if(data27.txt !== undefined){let data30 = data27.txt;const _errs67 = errors;if(errors === _errs67){if(data30 && typeof data30 == "object" && !Array.isArray(data30)){const _errs69 = errors;for(const key4 in data30){if(!(pattern0.test(key4))){const err5 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/txt",schemaPath:"#/definitions/bonjourQuery/properties/txt/additionalProperties",keyword:"additionalProperties",params:{additionalProperty: key4},message:"must NOT have additional properties"};if(vErrors === null){vErrors = [err5];}else {vErrors.push(err5);}errors++;break;}}if(_errs69 === errors){var valid15 = true;for(const key5 in data30){if(pattern0.test(key5)){const _errs70 = errors;if(typeof data30[key5] !== "string"){const err6 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/txt/" + key5.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/definitions/bonjourQuery/properties/txt/patternProperties//type",keyword:"type",params:{type: "string"},message:"must be string"};if(vErrors === null){vErrors = [err6];}else {vErrors.push(err6);}errors++;}var valid15 = _errs70 === errors;if(!valid15){break;}}}}}else {const err7 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/txt",schemaPath:"#/definitions/bonjourQuery/properties/txt/type",keyword:"type",params:{type: "object"},message:"must be object"};if(vErrors === null){vErrors = [err7];}else {vErrors.push(err7);}errors++;}}var valid14 = _errs67 === errors;}else {var valid14 = true;}}}}}}else {const err8 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/definitions/bonjourQuery/type",keyword:"type",params:{type: "object"},message:"must be object"};if(vErrors === null){vErrors = [err8];}else {vErrors.push(err8);}errors++;}}var _valid0 = _errs59 === errors;if(_valid0){valid12 = true;passing0 = 0;}const _errs72 = errors;if(errors === _errs72){if(Array.isArray(data27)){var valid16 = true;const len4 = data27.length;for(let i8=0; i8<len4; i8++){let data32 = data27[i8];const _errs74 = errors;const _errs75 = errors;if(errors === _errs75){if(data32 && typeof data32 == "object" && !Array.isArray(data32)){let missing4;if(((data32.type === undefined) && (missing4 = "type")) || ((data32.protocol === undefined) && (missing4 = "protocol"))){const err9 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8,schemaPath:"#/definitions/bonjourQuery/required",keyword:"required",params:{missingProperty: missing4},message:"must have required property '"+missing4+"'"};if(vErrors === null){vErrors = [err9];}else {vErrors.push(err9);}errors++;}else {const _errs77 = errors;for(const key6 in data32){if(!(((key6 === "type") || (key6 === "protocol")) || (key6 === "txt"))){const err10 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8,schemaPath:"#/definitions/bonjourQuery/additionalProperties",keyword:"additionalProperties",params:{additionalProperty: key6},message:"must NOT have additional properties"};if(vErrors === null){vErrors = [err10];}else {vErrors.push(err10);}errors++;break;}}if(_errs77 === errors){if(data32.type !== undefined){const _errs78 = errors;if(typeof data32.type !== "string"){const err11 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8+"/type",schemaPath:"#/definitions/bonjourQuery/properties/type/type",keyword:"type",params:{type: "string"},message:"must be string"};if(vErrors === null){vErrors = [err11];}else {vErrors.push(err11);}errors++;}var valid18 = _errs78 === errors;}else {var valid18 = true;}if(valid18){if(data32.protocol !== undefined){let data34 = data32.protocol;const _errs80 = errors;if(typeof data34 !== "string"){const err12 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8+"/protocol",schemaPath:"#/definitions/bonjourQuery/properties/protocol/type",keyword:"type",params:{type: "string"},message:"must be string"};if(vErrors === null){vErrors = [err12];}else {vErrors.push(err12);}errors++;}if(!((data34 === "tcp") || (data34 === "udp"))){const err13 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8+"/protocol",schemaPath:"#/definitions/bonjourQuery/properties/protocol/enum",keyword:"enum",params:{allowedValues: schema23.properties.protocol.enum},message:"must be equal to one of the allowed values"};if(vErrors === null){vErrors = [err13];}else {vErrors.push(err13);}errors++;}var valid18 = _errs80 === errors;}else {var valid18 = true;}if(valid18){if(data32.txt !== undefined){let data35 = data32.txt;const _errs82 = errors;if(errors === _errs82){if(data35 && typeof data35 == "object" && !Array.isArray(data35)){const _errs84 = errors;for(const key7 in data35){if(!(pattern0.test(key7))){const err14 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8+"/txt",schemaPath:"#/definitions/bonjourQuery/properties/txt/additionalProperties",keyword:"additionalProperties",params:{additionalProperty: key7},message:"must NOT have additional properties"};if(vErrors === null){vErrors = [err14];}else {vErrors.push(err14);}errors++;break;}}if(_errs84 === errors){var valid19 = true;for(const key8 in data35){if(pattern0.test(key8)){const _errs85 = errors;if(typeof data35[key8] !== "string"){const err15 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8+"/txt/" + key8.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/definitions/bonjourQuery/properties/txt/patternProperties//type",keyword:"type",params:{type: "string"},message:"must be string"};if(vErrors === null){vErrors = [err15];}else {vErrors.push(err15);}errors++;}var valid19 = _errs85 === errors;if(!valid19){break;}}}}}else {const err16 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8+"/txt",schemaPath:"#/definitions/bonjourQuery/properties/txt/type",keyword:"type",params:{type: "object"},message:"must be object"};if(vErrors === null){vErrors = [err16];}else {vErrors.push(err16);}errors++;}}var valid18 = _errs82 === errors;}else {var valid18 = true;}}}}}}else {const err17 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1")+"/" + i8,schemaPath:"#/definitions/bonjourQuery/type",keyword:"type",params:{type: "object"},message:"must be object"};if(vErrors === null){vErrors = [err17];}else {vErrors.push(err17);}errors++;}}var valid16 = _errs74 === errors;if(!valid16){break;}}}else {const err18 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/properties/bonjourQueries/patternProperties//oneOf/1/type",keyword:"type",params:{type: "array"},message:"must be array"};if(vErrors === null){vErrors = [err18];}else {vErrors.push(err18);}errors++;}}var _valid0 = _errs72 === errors;if(_valid0 && valid12){valid12 = false;passing0 = [passing0, 1];}else {if(_valid0){valid12 = true;passing0 = 1;}}if(!valid12){const err19 = {instancePath:instancePath+"/bonjourQueries/" + key2.replace(/~/g, "~0").replace(/\//g, "~1"),schemaPath:"#/properties/bonjourQueries/patternProperties//oneOf",keyword:"oneOf",params:{passingSchemas: passing0},message:"must match exactly one schema in oneOf"};if(vErrors === null){vErrors = [err19];}else {vErrors.push(err19);}errors++;validate20.errors = vErrors;return false;}else {errors = _errs58;if(vErrors !== null){if(_errs58){vErrors.length = _errs58;}else {vErrors = null;}}}var valid11 = _errs57 === errors;if(!valid11){break;}}}}}else {validate20.errors = [{instancePath:instancePath+"/bonjourQueries",schemaPath:"#/properties/bonjourQueries/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}var valid0 = _errs54 === errors;}else {var valid0 = true;}}}}}}}}}}}}}}}}}}}else {validate20.errors = [{instancePath,schemaPath:"#/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}validate20.errors = vErrors;return errors === 0;}