# @companion-module/base

This module provides the base class and framework needed to write a module for [Companion 3.0](https://github.com/bitfocus/companion) and later in NodeJS.

In the future it will be possible to write modules in other languages, but it is not recommended as it will reduce the change of gettings other in the community to contribute features and fixes. If you interested in doing this then reach out and we can work together on creating an alternate framework for the language you are using.

## Supported versions of this library

Each version of Companion supports a limited range of versions of this library listed below. Any patch version (the third number) are not relevant for the compatibility check, so are not listed here

| Companion | Module-base               |
| --------- | ------------------------- |
| v3.0      | v1.0 - v1.4               |
| v3.1      | v1.0 - v1.5               |
| v3.2      | v1.0 - v1.7               |
| v3.3      | v1.0 - v1.8               |
| v3.4      | v1.0 - v1.10 (unconfirmed) |
| v3.5      | v1.0 - v1.11 (unconfirmed) |

## Getting started with a new module

To get started with creating a new module, you should start with one of the following templates. These should be kept up to date, but you should make sure all the dependencies are up to date before you begin.

- https://github.com/bitfocus/companion-module-template-js (JavaScript)
- https://github.com/bitfocus/companion-module-template-ts (TypeScript)

## Documentation

You can view detailed generated documentation [here](https://bitfocus.github.io/companion-module-base/).

Or refer to [the wiki](https://github.com/bitfocus/companion-module-base/wiki) for a more handwritten version
